//===========================================================================
//                                              FASTER GRAPHICS USING TBitmap
//                                                                13 May 2013
//                   Take note of the right-justified lines ending with *****
//===========================================================================
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

//===========================================================================
//                                                                  VARIABLES
//===========================================================================

Graphics::TBitmap* graphicBMP = new Graphics::TBitmap();             // *****
int interval = 3;
bool stop = true;

//===========================================================================
//                                                                  VARIABLES
//===========================================================================

void erase (void) {
	graphicBMP->Canvas->Brush->Color = clLime;
	graphicBMP->Canvas->Pen->Color = clRed;
	graphicBMP->Canvas->Rectangle(0, 0, 500, 500);
}

void draw (void) {
	erase();
	graphicBMP->Canvas->MoveTo(0, 0);
	for (int i = 0; i < 500 + interval; i += interval) {
			graphicBMP->Canvas->MoveTo(i, 0);
			graphicBMP->Canvas->LineTo(500, i);
			graphicBMP->Canvas->LineTo(500 - i, 500);
			graphicBMP->Canvas->LineTo(0, 500 - i);
			graphicBMP->Canvas->LineTo(i, 0);
			// Application->ProcessMessages();  // these are not OK
	}
// 	Application->ProcessMessages();             // these are not OK
	Form1->PaintBoxGraphic->Canvas->Draw(0, 0, graphicBMP);          // *****
//  if you interrupt TBitmap processes you will                      // *****
//  get an AccessViolation in ntdll.dll                              // *****
}

void cycle (void) {
	while (stop == false) {
		for (interval = 3; interval < 50; interval++) {
			draw();
			Sleep(10);
		}
		Application->ProcessMessages();        // these are OK
		if (stop == false) {
			for (interval = 50; interval >= 3; interval--) {
				draw();
				Sleep(10);
			}
		}
		Application->ProcessMessages();        // these are OK
	}
}

//===========================================================================
//                                                                  VARIABLES
//===========================================================================

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	// set the width and height of the bitmap to match the PaintBox
	graphicBMP->Width = 500;                                         // *****
	graphicBMP->Height = 500;                                        // *****
	DoubleBuffered = true;                                           // *****
}

//---------------------------------------------------------------------------
void __fastcall TForm1::TrackBarIntervalChange(TObject *Sender)
{
	interval = TrackBarInterval->Position;
	Form1->EditPoints->Text = interval;
	draw();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
	stop = true;
	// clean house
	delete graphicBMP;                                               // *****
}

//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStartStopClick(TObject *Sender)
{
	stop = !stop;
	if (stop) Form1->ButtonStartStop->Caption = "Cycle";
	else Form1->ButtonStartStop->Caption = "Stop";
	cycle();
}
//---------------------------------------------------------------------------



